<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('pupils', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('parent')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('pupils', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('pupils', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('pupils', function(Blueprint $table) {
			$table->foreign('updated_by')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('classes', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('classes', function(Blueprint $table) {
			$table->foreign('updated_by')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('teacherSubjects', function(Blueprint $table) {
			$table->foreign('teacher_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('teacherSubjects', function(Blueprint $table) {
			$table->foreign('subject_id')->references('id')->on('subjects')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('teacherSubjects', function(Blueprint $table) {
			$table->foreign('class_id')->references('id')->on('classes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('permissionRole', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('permissionRole', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('permissions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('performances', function(Blueprint $table) {
			$table->foreign('classpupil_id')->references('id')->on('classPupil')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('performances', function(Blueprint $table) {
			$table->foreign('subject_id')->references('id')->on('subjects')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('performances', function(Blueprint $table) {
			$table->foreign('class_id')->references('id')->on('classes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('performances', function(Blueprint $table) {
			$table->foreign('teacher_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('performances', function(Blueprint $table) {
			$table->foreign('test_id')->references('id')->on('tests')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('performances', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('performances', function(Blueprint $table) {
			$table->foreign('term_id')->references('id')->on('terms')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('classPupil', function(Blueprint $table) {
			$table->foreign('pupil_id')->references('id')->on('pupils')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('classPupil', function(Blueprint $table) {
			$table->foreign('class_id')->references('id')->on('classes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('parent', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('parent', function(Blueprint $table) {
			$table->foreign('updated_by')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('pupils', function(Blueprint $table) {
			$table->dropForeign('pupils_parent_id_foreign');
		});
		Schema::table('pupils', function(Blueprint $table) {
			$table->dropForeign('pupils_branch_id_foreign');
		});
		Schema::table('pupils', function(Blueprint $table) {
			$table->dropForeign('pupils_created_by_foreign');
		});
		Schema::table('pupils', function(Blueprint $table) {
			$table->dropForeign('pupils_updated_by_foreign');
		});
		Schema::table('classes', function(Blueprint $table) {
			$table->dropForeign('classes_created_by_foreign');
		});
		Schema::table('classes', function(Blueprint $table) {
			$table->dropForeign('classes_updated_by_foreign');
		});
		Schema::table('teacherSubjects', function(Blueprint $table) {
			$table->dropForeign('teacherSubjects_teacher_id_foreign');
		});
		Schema::table('teacherSubjects', function(Blueprint $table) {
			$table->dropForeign('teacherSubjects_subject_id_foreign');
		});
		Schema::table('teacherSubjects', function(Blueprint $table) {
			$table->dropForeign('teacherSubjects_class_id_foreign');
		});
		Schema::table('permissionRole', function(Blueprint $table) {
			$table->dropForeign('permissionRole_role_id_foreign');
		});
		Schema::table('permissionRole', function(Blueprint $table) {
			$table->dropForeign('permissionRole_permission_id_foreign');
		});
		Schema::table('performances', function(Blueprint $table) {
			$table->dropForeign('performances_classpupil_id_foreign');
		});
		Schema::table('performances', function(Blueprint $table) {
			$table->dropForeign('performances_subject_id_foreign');
		});
		Schema::table('performances', function(Blueprint $table) {
			$table->dropForeign('performances_class_id_foreign');
		});
		Schema::table('performances', function(Blueprint $table) {
			$table->dropForeign('performances_teacher_id_foreign');
		});
		Schema::table('performances', function(Blueprint $table) {
			$table->dropForeign('performances_test_id_foreign');
		});
		Schema::table('performances', function(Blueprint $table) {
			$table->dropForeign('performances_branch_id_foreign');
		});
		Schema::table('performances', function(Blueprint $table) {
			$table->dropForeign('performances_term_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_role_id_foreign');
		});
		Schema::table('classPupil', function(Blueprint $table) {
			$table->dropForeign('classPupil_pupil_id_foreign');
		});
		Schema::table('classPupil', function(Blueprint $table) {
			$table->dropForeign('classPupil_class_id_foreign');
		});
		Schema::table('parent', function(Blueprint $table) {
			$table->dropForeign('parent_created_by_foreign');
		});
		Schema::table('parent', function(Blueprint $table) {
			$table->dropForeign('parent_updated_by_foreign');
		});
	}
}