<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'email', 'username', 'password', 'role_id');
    protected $visible = array('name', 'email', 'username', 'role_id');
    protected $hidden = array('password');

    public function role()
    {
        return $this->belongsTo('Role');
    }

}