<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientContactTable extends Migration {

	public function up()
	{
		Schema::create('client_contact', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('first_name', 255);
			$table->string('last_name', 255);
			$table->string('email', 255);
			$table->string('phone_primary', 20);
			$table->string('phone_secondary', 20);
			$table->string('phone_tertiary', 20);
			$table->enum('type', array('primary', 'billing', 'reporting'));
			$table->integer('client_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('client_contact');
	}
}