<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCampaignsTable extends Migration {

	public function up()
	{
		Schema::create('campaigns', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('client_id')->unsigned();
			$table->string('website', 255);
			$table->double('revenue');
			$table->integer('campaign_manager_id')->unsigned();
			$table->integer('client_lead_id')->unsigned();
			$table->integer('digital_strategist_id')->unsigned();
			$table->enum('status', array('active', 'paused', 'cancelled', 'suspended'));
			$table->date('live_date');
			$table->date('end_date');
			$table->integer('campaign_type_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('campaigns');
	}
}