<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCampaignTypeFieldsTable extends Migration {

	public function up()
	{
		Schema::create('campaign_type_fields', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('campaign_type_id')->unsigned();
			$table->string('field_name', 255);
			$table->enum('field_type', array('number', 'string', 'currency', 'file'));
		});
	}

	public function down()
	{
		Schema::drop('campaign_type_fields');
	}
}