<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Campaign extends Eloquent {

	protected $table = 'campaigns';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function campaignNotes()
	{
		return $this->hasMany('Note', 'parent_id');
	}

	public function campaignManager()
	{
		return $this->hasOne('User', 'campaign_manager_id');
	}

	public function campaignClientLead()
	{
		return $this->hasOne('User', 'client_lead_id');
	}

	public function campaignDigitalStrategist()
	{
		return $this->hasOne('User', 'digital_strategist_id');
	}

	public function campaignType()
	{
		return $this->hasOne('CampaignType', 'campaign_type_id');
	}

}