<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->bigInteger('id', true)->primary();
			$table->string('name', 255);
			$table->string('email', 200);
			$table->string('phone', 50);
			$table->string('password', 255);
			$table->tinyInteger('type')->default('1');
			$table->tinyInteger('gender')->nullable()->default('0');
			$table->tinyInteger('status')->default('0');
			$table->date('birthdate')->nullable();
			$table->tinyInteger('residency_type')->default('1');
			$table->string('residency_number', 255)->nullable();
			$table->string('civil_id', 255)->nullable();
			$table->string('code', 50)->nullable();
			$table->datetime('verified_at')->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}