<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PropertyModel extends Model 
{

    protected $table = 'property';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function images()
    {
        return $this->hasMany('App\PropertyImagesModel', 'property_id');
    }

    public function type()
    {
        return $this->belongsTo('App\PropertyTypesModel', 'property_type_id');
    }

    public function areaUnit()
    {
        return $this->belongsTo('App\AreaUnitModel', 'area_unit_id');
    }

    public function seller()
    {
        return $this->belongsTo('App\SellerProfileModel', 'seller_id');
    }

}