<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateChildrenTable extends Migration {

	public function up()
	{
		Schema::create('children', function(Blueprint $table) {
			$table->increments('id');
			$table->string('login_id', 100);
			$table->string('name', 50)->nullable();
			$table->string('photo', 500)->nullable();
			$table->date('birthday')->nullable();
			$table->enum('gender', array('male', 'female', 'etc'));
			$table->string('postcode', 10)->nullable();
			$table->string('address', 255)->nullable();
			$table->string('address_detail', 255)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('children');
	}
}