<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAcademiesTable extends Migration {

	public function up()
	{
		Schema::create('academies', function(Blueprint $table) {
			$table->increments('id');
			$table->string('owner_id', 100);
			$table->enum('type', array('kindergarten', 'academy'));
			$table->string('name', 255)->nullable();
			$table->string('nickname', 255)->nullable();
			$table->string('rep_name', 255)->nullable();
			$table->string('mgr_name', 255)->nullable();
			$table->string('mgr_mobile', 255)->nullable();
			$table->string('mgr_email', 255)->nullable();
			$table->string('phone', 50)->nullable();
			$table->string('postcode', 10)->nullable();
			$table->string('address', 255)->nullable();
			$table->string('address_detail', 255)->nullable();
			$table->enum('status', array('pending', 'active', 'inactive'))->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('academies');
	}
}