<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCommonFieldsTable extends Migration {

	public function up()
	{
		Schema::create('common_fields', function(Blueprint $table) {
			$table->increments('id');
			$table->string('id_rel', 10);
			$table->string('tabla', 50);
			$table->text('title')->nullable();
			$table->text('description')->nullable();
			$table->string('robots', 100);
			$table->string('h1');
			$table->string('nombre')->nullable();
			$table->string('descripcion_corta', 510)->nullable();
			$table->text('contenido')->nullable();
			$table->string('foto_principal', 255)->nullable();
			$table->string('foto_listado', 255)->nullable();
			$table->string('slug')->unique();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('common_fields');
	}
}