<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('releases', function(Blueprint $table) {
			$table->foreign('profile_id')->references('id')->on('profiles')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('tracks', function(Blueprint $table) {
			$table->foreign('release_id')->references('id')->on('releases')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('mixes', function(Blueprint $table) {
			$table->foreign('track_id')->references('id')->on('tracks')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('mixes', function(Blueprint $table) {
			$table->foreign('genre_id')->references('id')->on('genres')
						->onDelete('set null')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('releases', function(Blueprint $table) {
			$table->dropForeign('releases_profile_id_foreign');
		});
		Schema::table('tracks', function(Blueprint $table) {
			$table->dropForeign('tracks_release_id_foreign');
		});
		Schema::table('mixes', function(Blueprint $table) {
			$table->dropForeign('mixes_track_id_foreign');
		});
		Schema::table('mixes', function(Blueprint $table) {
			$table->dropForeign('mixes_genre_id_foreign');
		});
	}
}