<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVehicleInfoTable extends Migration {

	public function up()
	{
		Schema::create('vehicle_info', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('schedule_management_id');
			$table->string('vehicle_number', 56);
			$table->string('driver_name', 56)->nullable();
			$table->string('driver_number', 20)->nullable();
			$table->double('quantity');
			$table->integer('mst_regions_id')->nullable();
			$table->tinyInteger('status')->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('vehicle_info');
	}
}