<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('inserzione', function(Blueprint $table) {
			$table->foreign('indirizzo_id')->references('id')->on('indirizzo')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('inserzione', function(Blueprint $table) {
			$table->foreign('tipoinserzione_id')->references('id')->on('tipoinserzione')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('recensione', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('inserzione', function(Blueprint $table) {
			$table->dropForeign('inserzione_indirizzo_id_foreign');
		});
		Schema::table('inserzione', function(Blueprint $table) {
			$table->dropForeign('inserzione_tipoinserzione_id_foreign');
		});
		Schema::table('recensione', function(Blueprint $table) {
			$table->dropForeign('recensione_user_id_foreign');
		});
	}
}