<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBuyerTable extends Migration {

	public function up()
	{
		Schema::create('buyer', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('name');
			$table->string('avatar')->nullable();
			$table->datetime('member_since')->nullable();
			$table->bigInteger('bucket_id')->unsigned();
			$table->string('contact_name')->nullable();
			$table->string('contact_no')->nullable();
			$table->string('email');
			$table->text('address')->nullable();
			$table->text('description')->nullable();
			$table->boolean('active')->default(1);
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('buyer');
	}
}