<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductTable extends Migration {

	public function up()
	{
		Schema::create('product', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('name');
			$table->string('avatar')->nullable();
			$table->double('price', 8,2)->nullable();
			$table->bigInteger('grade_id')->unsigned();
			$table->bigInteger('finish_id')->unsigned();
			$table->bigInteger('edge_id')->unsigned();
			$table->string('uom');
			$table->bigInteger('uom_id')->unsigned();
			$table->boolean('coil')->default(0);
			$table->double('thickness', 8,2);
			$table->integer('width');
			$table->integer('length')->nullable();
			$table->integer('rsl')->nullable();
			$table->double('csl', 8,2)->nullable();
			$table->text('description')->nullable();
			$table->boolean('active')->default(1);
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('product');
	}
}