<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWitnessTable extends Migration {

	public function up()
	{
		Schema::create('witness', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->nullable();
			$table->string('position')->nullable();
			$table->string('statement')->nullable();
			$table->string('national_id')->nullable();
			$table->integer('hr_code')->nullable();
			$table->integer('incident_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('witness');
	}
}