<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectTable extends Migration {

	public function up()
	{
		Schema::create('project', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 250)->nullable();
			$table->integer('code')->nullable();
			$table->string('pm')->nullable();
			$table->string('hse_manager')->nullable();
			$table->string('owner')->nullable();
			$table->integer('sector_id')->nullable();
			$table->boolean('status')->nullable()->default(0);
		});
	}

	public function down()
	{
		Schema::drop('project');
	}
}