<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MaintenanceLog extends Model 
{

    protected $table = 'maintenance_log';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('equipment_id', 'project_id', 'task', 'performer', 'note', 'date');

    public function equipment()
    {
        return $this->belongsTo('Equipment', 'equipment_id');
    }

    public function project_id()
    {
        return $this->belongsTo('Project', 'project_id');
    }

}