<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Witness extends Eloquent {

	protected $table = 'witness';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'position', 'statement', 'national_id', 'hr_code', 'incident_id');

	public function incident()
	{
		return $this->belongsTo('Incident', 'incident_id');
	}

}