<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Voc extends Eloquent {

	protected $table = 'voc';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('engineer_id', 'project_id', 'note', 'date');

	public function engineer()
	{
		return $this->belongsTo('Engineer', 'engineer_id');
	}

	public function project()
	{
		return $this->belongsTo('Project', 'project_id');
	}

}