<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TheCase extends Eloquent {

	protected $table = 'the_case';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'date_of_birth', 'exp', 'start_date', 'direct_manager_id', 'occupation', 'national_id', 'hr_code', 'nature_of_injury', 'place_of_injury', 'incident_id', 'injury_type_id', 'no_of_lti');

	public function direct_manager()
	{
		return $this->belongsTo('Engineer', 'direct_manager_id');
	}

	public function incident()
	{
		return $this->belongsTo('Incident', 'incident_id');
	}

	public function injury_type()
	{
		return $this->belongsTo('InjuryType', 'injury_type_id');
	}

}