<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('email');
			$table->string('password');
			$table->string('national_id');
			$table->string('photo');
			$table->bigInteger('wallet')->unique();
			$table->string('full_name');
			$table->string('phone_number')->unique();
			$table->tinyInteger('nafith_service')->default('0');
			$table->timestamps();
			$table->integer('parent_id');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}