<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoicesTable extends Migration {

	public function up()
	{
		Schema::create('invoices', function(Blueprint $table) {
			$table->increments('id');
			$table->date('date');
			$table->string('address');
			$table->decimal('sub_total');
			$table->decimal('discount');
			$table->decimal('total');
			$table->bigInteger('customer_id')->unsigned();
			$table->enum('status', array('complate', 'pending', 'cancel'));
		});
	}

	public function down()
	{
		Schema::drop('invoices');
	}
}