<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class StoreEntry extends Eloquent {

	protected $table = 'store_entry';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'store_id', 'client_id', 'source', 'type', 'number', 'goods_type', 'height', 'width', 'length', 'still_in', 'amount', 'area', 'note', 'chassis_number', 'car_type', 'price', 'cofactor_id');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function client()
	{
		return $this->belongsTo('Client', 'client_id');
	}

	public function cofactor()
	{
		return $this->belongsTo('Cofactor', 'cofactor_id');
	}

	public function store()
	{
		return $this->belongsTo('Store', 'store_id');
	}

}