<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuotationTable extends Migration {

	public function up()
	{
		Schema::create('quotation', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->nullable();
			$table->integer('client_id')->nullable();
			$table->text('notes')->nullable();
			$table->double('price')->nullable();
			$table->double('total')->nullable();
			$table->datetime('expired_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('quotation');
	}
}