<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuotationItemsTable extends Migration {

	public function up()
	{
		Schema::create('quotation_items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->nullable();
			$table->integer('quantity')->nullable();
			$table->double('price')->nullable();
			$table->double('shipping_price')->nullable();
			$table->integer('quotation_id')->nullable();
			$table->string('description')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('quotation_items');
	}
}