<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStoreEntryTable extends Migration {

	public function up()
	{
		Schema::create('store_entry', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->nullable();
			$table->integer('store_id')->nullable();
			$table->integer('client_id')->nullable();
			$table->string('source')->nullable();
			$table->enum('type', array('goods', 'car'))->nullable();
			$table->integer('number')->nullable();
			$table->string('goods_type')->nullable();
			$table->double('height')->nullable();
			$table->double('width')->nullable();
			$table->double('length')->nullable();
			$table->integer('exit_number')->nullable();
			$table->integer('still_in')->nullable();
			$table->double('amount')->nullable();
			$table->double('area')->nullable();
			$table->text('note')->nullable();
			$table->string('chassis_number')->nullable();
			$table->string('car_type')->nullable();
			$table->double('price')->nullable();
			$table->integer('cofactor_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('store_entry');
	}
}