<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ShippingClient extends Model 
{

    protected $table = 'shipping_client';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'shipping_id', 'client_id', 'total', 'total_after', 'total_contents', 'total_square', 'status', 'pay_status');

    public function shipping()
    {
        return $this->belongsTo('Shipping', 'shiping_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function client()
    {
        return $this->belongsTo('Client', 'client_id');
    }

    public function contents()
    {
        return $this->hasMany('ShippingContent', 'shipping_client_id');
    }

}