<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('trend_taxi_app_user_data', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('trend_taxi_app_users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('trend_taxi_app_past_trips', function(Blueprint $table) {
			$table->foreign('driver_id')->references('id')->on('trend_taxi_app_users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('trend_taxi_app_past_trips', function(Blueprint $table) {
			$table->foreign('passenger_id')->references('id')->on('trend_taxi_app_users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('trend_taxi_app_user_data', function(Blueprint $table) {
			$table->dropForeign('trend_taxi_app_user_data_user_id_foreign');
		});
		Schema::table('trend_taxi_app_past_trips', function(Blueprint $table) {
			$table->dropForeign('trend_taxi_app_past_trips_driver_id_foreign');
		});
		Schema::table('trend_taxi_app_past_trips', function(Blueprint $table) {
			$table->dropForeign('trend_taxi_app_past_trips_passenger_id_foreign');
		});
	}
}