<?php

namespace App/Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Department extends Model 
{

    protected $table = 'departments';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('department_type_id', 'facility_id', 'scope', 'meta_data', 'client_department_name', 'client_patient_term', 'client_department_type_name');

    public function departmentType()
    {
        return $this->belongsTo('App\Models\DepartmentType');
    }

    public function facility()
    {
        return $this->belongsTo('App\Models\Facility');
    }

    public function assessment()
    {
        return $this->hasMany('App\Models\Assessment');
    }

}