<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('first_name', 120)->nullable()->index();
			$table->string('last_name', 120)->nullable()->index();
			$table->string('user_name', 512)->unique();
			$table->string('email', 512)->nullable()->index();
			$table->string('password', 60);
			$table->string('legacy_user_id', 32)->nullable()->index();
			$table->string('contact_number', 20)->nullable();
			$table->enum('user_type', array('CLIENT', 'STAFF', 'ADMIN', 'SUPER-ADMIN'))->index();
			$table->boolean('disabled')->index()->default(0);
			$table->string('import_id', 64)->nullable();
			$table->string('source', 32)->nullable();
			$table->string('import_version', 15);
			$table->string('whitelist_ips')->nullable()->index()->default('jsaon');
			$table->string('token', 256)->unique()->nullable();
			$table->datetime('token_expires')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}