<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserPasswordHistoriesTable extends Migration {

	public function up()
	{
		Schema::create('user_password_histories', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->index();
			$table->timestamps();
			$table->string('password', 60)->index();
			$table->string('reason', 64)->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('user_password_histories');
	}
}