<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('Users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('user_name', 50);
			$table->string('user_password', 255);
			$table->string('remember_token', 255)->nullable();
			$table->tinyInteger('lock_enabled')->nullable();
			$table->tinyInteger('is_active');
			$table->smallInteger('login_attemps')->nullable();
			$table->datetime('lock_expired_at')->nullable();
			$table->tinyInteger('double_auth_active');
		});
	}

	public function down()
	{
		Schema::drop('Users');
	}
}