<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserInfosTable extends Migration {

	public function up()
	{
		Schema::create('UserInfos', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('firstname', 50);
			$table->string('lastname', 50);
			$table->string('address', 255);
			$table->string('email', 150);
			$table->string('other_email', 150)->nullable();
			$table->string('phone_number', 30);
			$table->string('postal_code')->nullable();
			$table->string('birthdate', 255)->nullable();
			$table->enum('sex', array(''));
			$table->integer('user_id')->unsigned();
			$table->integer('organinsation_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('UserInfos');
	}
}