<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('organinsations', function(Blueprint $table) {
			$table->foreign('wallet_id')->references('id')->on('wallets')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('organisationBanks', function(Blueprint $table) {
			$table->foreign('organinsation_id')->references('id')->on('organinsations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('organisationBanks', function(Blueprint $table) {
			$table->foreign('bank_id')->references('id')->on('banks')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('merchatns', function(Blueprint $table) {
			$table->foreign('wallet_id')->references('id')->on('wallets')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('walletTransactions', function(Blueprint $table) {
			$table->foreign('wallet_id')->references('id')->on('walletTransactions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('walletTransactions', function(Blueprint $table) {
			$table->foreign('merchant_id')->references('id')->on('merchatns')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('walletTransactions', function(Blueprint $table) {
			$table->foreign('transaction_initialized_by')->references('id')->on('UserInfos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('walletTransactions', function(Blueprint $table) {
			$table->foreign('transaction_validated_by')->references('id')->on('UserInfos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('UserInfos', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('UserInfos', function(Blueprint $table) {
			$table->foreign('organinsation_id')->references('id')->on('organinsations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('roleUsers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('roleUsers', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('PermissionRoles', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('permissions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('PermissionRoles', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('merchantPlateformConfigs', function(Blueprint $table) {
			$table->foreign('merchant_id')->references('id')->on('merchatns')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('organinsations', function(Blueprint $table) {
			$table->dropForeign('organinsations_wallet_id_foreign');
		});
		Schema::table('organisationBanks', function(Blueprint $table) {
			$table->dropForeign('organisationBanks_organinsation_id_foreign');
		});
		Schema::table('organisationBanks', function(Blueprint $table) {
			$table->dropForeign('organisationBanks_bank_id_foreign');
		});
		Schema::table('merchatns', function(Blueprint $table) {
			$table->dropForeign('merchatns_wallet_id_foreign');
		});
		Schema::table('walletTransactions', function(Blueprint $table) {
			$table->dropForeign('walletTransactions_wallet_id_foreign');
		});
		Schema::table('walletTransactions', function(Blueprint $table) {
			$table->dropForeign('walletTransactions_merchant_id_foreign');
		});
		Schema::table('walletTransactions', function(Blueprint $table) {
			$table->dropForeign('walletTransactions_transaction_initialized_by_foreign');
		});
		Schema::table('walletTransactions', function(Blueprint $table) {
			$table->dropForeign('walletTransactions_transaction_validated_by_foreign');
		});
		Schema::table('UserInfos', function(Blueprint $table) {
			$table->dropForeign('UserInfos_user_id_foreign');
		});
		Schema::table('UserInfos', function(Blueprint $table) {
			$table->dropForeign('UserInfos_organinsation_id_foreign');
		});
		Schema::table('roleUsers', function(Blueprint $table) {
			$table->dropForeign('roleUsers_user_id_foreign');
		});
		Schema::table('roleUsers', function(Blueprint $table) {
			$table->dropForeign('roleUsers_role_id_foreign');
		});
		Schema::table('PermissionRoles', function(Blueprint $table) {
			$table->dropForeign('PermissionRoles_permission_id_foreign');
		});
		Schema::table('PermissionRoles', function(Blueprint $table) {
			$table->dropForeign('PermissionRoles_role_id_foreign');
		});
		Schema::table('merchantPlateformConfigs', function(Blueprint $table) {
			$table->dropForeign('merchantPlateformConfigs_merchant_id_foreign');
		});
	}
}