<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSMSTable extends Migration {

	public function up()
	{
		Schema::create('s_m_s', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('destination')->index();
			$table->string('origin')->index();
			$table->enum('direction', array('-1', '1'));
			$table->string('message');
			$table->datetime('sent')->nullable();
			$table->datetime('received')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('s_m_s');
	}
}