<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Invitations extends Model 
{

    protected $table = 'invitations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('order_id', 'lawyer_id', 'price', 'days_offer', 'period', 'status', 'cancel', 'review');

    public function order()
    {
        return $this->belongsTo('Orders', 'order_id');
    }

    public function lawyer()
    {
        return $this->belongsTo('Lawyers', 'lawyer_id');
    }

}