<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Licenses extends Model 
{

    protected $table = 'licenses';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('start_at', 'expire_at', 'license_number', 'type', 'country_id', 'lawyer_id');

    public function lawyer()
    {
        return $this->belongsTo('Lawyers', 'lawyer_id');
    }

    public function country()
    {
        return $this->belongsTo('Countries', 'country_id');
    }

}