<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLawyersTable extends Migration {

	public function up()
	{
		Schema::create('lawyers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->string('email');
			$table->string('phone');
			$table->integer('country_id');
			$table->integer('city_id');
			$table->double('advice_price');
			$table->string('password');
			$table->date('birth_date');
			$table->enum('gender', array('male', 'female'));
			$table->text('brief');
			$table->integer('level_id');
			$table->enum('status', array('active', 'inactive'));
			$table->enum('available', array('available', 'unavailable'));
			$table->string('user_id');
			$table->integer('waiting_from');
			$table->integer('waiting_to');
			$table->integer('bank_id');
			$table->string('account_name');
			$table->double('balance');
			$table->string('account_number');
			$table->string('iban');
			$table->integer('rating');
		});
	}

	public function down()
	{
		Schema::drop('lawyers');
	}
}