<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvitationsTable extends Migration {

	public function up()
	{
		Schema::create('invitations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('order_id');
			$table->integer('lawyer_id');
			$table->double('price');
			$table->integer('days_offer');
			$table->integer('period');
			$table->enum('status', array('refuse', 'accept'));
			$table->enum('cancel', array('q1', 'q2', 'q3', 'q4'))->nullable();
			$table->string('review');
		});
	}

	public function down()
	{
		Schema::drop('invitations');
	}
}