<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProvidersTable extends Migration {

	public function up()
	{
		Schema::create('providers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 150);
			$table->integer('city_id')->unsigned();
			$table->string('phone', 100);
			$table->string('country_code', 10);
			$table->string('email', 255);
			$table->string('commercial_id', 255);
			$table->string('commercial_image', 150);
			$table->string('code', 10);
			$table->boolean('active')->default(0);
			$table->integer('approve')->default('0');
			$table->integer('activity_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('providers');
	}
}