<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function phones()
	{
		return $this->hasMany('ClientPhone');
	}

	public function addresses()
	{
		return $this->hasMany('Address', 'client_id');
	}

	public function orders()
	{
		return $this->hasMany('Order', 'client_id');
	}

}