<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->string('uuid');
			$table->datetime('confirmed_at');
			$table->integer('allocation_id')->unsigned()->index();
			$table->enum('currency', array('wozx', 'usdt'));
			$table->json('transaction_details');
			$table->string('transaction_hash')->unique();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('transactions');
	}
}