<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAccountServiceOptionsTable extends Migration {

	public function up()
	{
		Schema::create('account_service_options', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('account_service_id')->unsigned();
			$table->string('title', 9);
			$table->text('description');
			$table->decimal('price', 8,2)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('account_service_options');
	}
}