<?php

namespace App\Models;

class City extends Eloquent {

	protected $table = 'cities';
	public $timestamps = true;
	protected $fillable = array('name', 'governorate_id');

	public function clients()
	{
		return $this->hasMany('App\Models\Client');
	}

	public function DonationRequests()
	{
		return $this->hasMany('App\Models\DonationRequest');
	}

	public function Governorate()
	{
		return $this->belongsTo('App\Models\Governorate');
	}

}