<?php

namespace Ticket;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Ticket extends Eloquent {

	protected $table = 'ticket';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function getInteractionsAttibute()
	{
		return $this->hasMany('Interaction');
	}

	public function getTicketHistory()
	{
		return $this->hasOne('History');
	}

	public function getCategoryTicket()
	{
		return $this->hasOne('Category');
	}

}