<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMessagesTable extends Migration {

	public function up()
	{
		Schema::create('messages', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('thread_id')->unsigned()->index();
			$table->enum('message_type', array(''text'', ''image'', ''extra''))->nullable();
			$table->text('extra')->nullable();
			$table->text('body')->nullable();
			$table->string('image', 255)->nullable();
			$table->date('read_ad')->nullable();
			$table->string('from_type');
			$table->integer('from_id')->unsigned()->index();
			$table->string('to_type');
			$table->integer('to_id')->unsigned()->index();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('messages');
	}
}