<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdsTable extends Migration {

	public function up()
	{
		Schema::create('ads', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('city_id');
			$table->bigInteger('district_id')->nullable();
			$table->bigInteger('screen_id');
			$table->double('screen_no');
			$table->tinyInteger('ad_type');
			$table->string('ad_file')->nullable();
			$table->bigInteger('marketer_id')->nullable();
			$table->tinyInteger('status');
			$table->bigInteger('packge_id')->nullable();
			$table->bigInteger('category_id')->nullable();
			$table->double('weeks');
			$table->date('start_date');
			$table->double('seconds');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('ads');
	}
}