<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompanyTable extends Migration {

	public function up()
	{
		Schema::create('company', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->nullable();
			$table->string('company_name')->nullable();
			$table->string('employee_number')->nullable();
			$table->integer('country_id')->nullable();
			$table->integer('active_members')->nullable();
			$table->datetime('start_at')->nullable();
			$table->datetime('expire_at')->nullable();
			$table->datetime('grace_at')->nullable();
			$table->string('company_domain')->nullable();
			$table->integer('max_members')->nullable();
			$table->boolean('is_trial')->default(0);
			$table->boolean('active')->default(0);
			$table->integer('period')->nullable();
			$table->integer('active_order_id')->nullable();
			$table->datetime('support_start_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('company');
	}
}